<?php declare(strict_types = 1);

namespace Core\Model\Http;

use Core\Model\BotDetect;
use Nette\Http\SessionSection;

class Session extends \Nette\Http\Session
{
	protected static bool $botChecked = false;

	public function start(): void
	{
		if (self::$botChecked || BotDetect::isBot()) {
			self::$botChecked = true;

			if (session_status() === PHP_SESSION_ACTIVE)
				$this->destroy();

			return;
		}

		parent::start();
	}

	public function setOptions(array $options)
	{
		if (self::$botChecked || BotDetect::isBot())
			return $this;

		return parent::setOptions($options);
	}

	public function setExpiration(?string $time)
	{
		if (self::$botChecked || BotDetect::isBot())
			return $this;

		return parent::setExpiration($time);
	}

	public function exists(): bool
	{
		if (self::$botChecked || BotDetect::isBot())
			return false;

		return parent::exists();
	}

	public function getName(): string
	{
		if (self::$botChecked || BotDetect::isBot())
			return '';

		return parent::getName();
	}

	public function getSection(string $section, string $class = SessionSection::class): SessionSection
	{
		if (self::$botChecked || BotDetect::isBot()) {
			return parent::getSection($section, DummySessionSection::class);
		}

		return parent::getSection($section, $class);
	}

}
