<?php declare(strict_types = 1);

namespace Core\Model\Images;

use Nette;

/**
 *
 * @property-read string $file
 * @property-read Size   $size
 */
class Image
{
	use Nette\SmartObject;

	/** @var string */
	private $file;
	/** @var Size */
	private $size;

	/**
	 * @param string $file
	 */
	public function __construct($file)
	{
		$this->file = $file;
		$this->size = Size::fromFile($file);
	}

	/**
	 * @return bool
	 */
	public function exists()
	{
		return file_exists($this->file);
	}

	public function getFile(): ?string { return $this->file; }

	/**
	 * @return string
	 */
	public function getBasename()
	{
		return basename($this->getFile());
	}

	/**
	 * @return Size
	 */
	public function getSize()
	{
		return $this->size;
	}

	/**
	 * @return string
	 */
	public function __toString()
	{
		return $this->getBasename();
	}
}
