<?php declare(strict_types = 1);

namespace Core\Model\Images;

use Nette;

/**
 * @property-read float|int $width
 * @property-read float|int $height
 */
class Size
{
	use Nette\SmartObject;

	/** @var float|int */
	private $width;

	/** @var float|int */
	private $height;

	/**
	 * @param float|int $width
	 * @param float|int $height
	 */
	public function __construct($width, $height)
	{
		$this->width  = $width;
		$this->height = $height;
	}

	/**
	 * @return float|int
	 */
	public function getHeight()
	{
		return $this->height;
	}

	/**
	 * @return float|int
	 */
	public function getWidth()
	{
		return $this->width;
	}

	public static function fromFile(string $file): Size
	{
		$tmp = @getimagesize($file);

		return is_array($tmp)
			? new Size($tmp[0], $tmp[1])
			: new Size(0, 0);
	}

}
