<?php declare(strict_types = 1);

namespace Core\Model\Router;

use Core\Model\SystemConfig;
use Nette\Routing\Router;

class RouterFactory
{
	protected RouteHelper $routeHelper;

	protected array $defaultAdminRoute;

	public function __construct(
		array $defaultAdminRoute,
		RouteHelper $routeHelper
	)
	{
		$this->defaultAdminRoute = $defaultAdminRoute;
		$this->routeHelper       = $routeHelper;
	}

	public function createRouter(): RouteList
	{
		$router = new RouteList;

		$router[] = new Route('/robots.txt', 'Core:Front:Robots:default', Router::ONE_WAY);
		$router[] = new Route('/sitemap-<site>-<group>-<lang>.xml', 'Core:Front:Sitemap:default', Router::ONE_WAY);

		$adminRouteMask = SystemConfig::load('adminRouteMask') ?: '/admin/<module>/<presenter>[/<action>[/<id>]]';

		$admin   = new RouteListAdmin;
		$admin[] = $this->routeHelper->createAdminRoute($adminRouteMask, [
			'module'    => $this->defaultAdminRoute['module'],
			'presenter' => $this->defaultAdminRoute['presenter'],
			'action'    => $this->defaultAdminRoute['action'],
			'id'        => $this->defaultAdminRoute['id'],
		]);

		$router[] = $admin;

		$router[] = $cron = new RouteListAdmin;
		$cron[]   = $this->routeHelper->createAdminRoute('/cron/<module>/<presenter>[/<action>[/<id>]]', [
			'module'    => 'Dashboard:Cron',
			'presenter' => 'Default',
			'action'    => 'default'])->setModule('Cron');

		$router[] = $admin = new RouteList('Core:Admin');
		foreach (['filesmanager' => 'FilesManager'] as $url => $presenter) {
			$admin[] = $this->routeHelper->createAdminRoute(str_replace('<module>/<presenter>', $url, $adminRouteMask), [
				'presenter' => $presenter,
				'action'    => 'default',
				'id'        => null,
			]);
		}

		return $router;
	}
}
