<?php declare(strict_types = 1);

namespace Core\Model\TemplateReader;

use Core\Model\TemplateReader\Entity\ITemplate;
use Core\Model\UI\AbstractPresenter;
use Core\Model\UI\BaseControl;
use Nette\ComponentModel\IComponent;
use Nette\Http\Request;
use Pages\Model\Paths;

/**
 * TODO Předělat celé do komponenty formuláře.
 */
abstract class TemplateReaderControl extends BaseControl implements ITemplateReaderControl
{
	/** @var ITemplate|null */
	protected $entity;

	/** @var Request @inject */
	public $httpRequest;

	/** @var TemplateReader @inject */
	public $templateReader;

	/** @var Paths @inject */
	public $pathsService;

	/** @var string @persistent */
	public $selectedTemplate;

	protected function attached(IComponent $presenter): void
	{
		parent::attached($presenter);

		/** @var AbstractPresenter $presenter */
		$this->templateReader->uiControl = $presenter;

		$httpTemplate = null;
		if ($this->httpRequest->getPost('template')) {
			$httpTemplate = $this->httpRequest->getPost('template');
		} else if ($this->selectedTemplate) {
			$httpTemplate = $this->selectedTemplate;
		}

		$tmp = explode('|', (string) $httpTemplate);
		if (count($tmp) === 2) {
			$this->templateReader->setTemplatesDir($this->pathsService->getTemplatePagesDir($tmp[0]));
			$httpTemplate = $tmp[1];
		}

		if (!$this->entity && $httpTemplate) {
			$this->templateReader->loadTemplateComponents($this['form']['component'], $httpTemplate, []);
		}
	}

	/*******************************************************************************************************************
	 * ==================  Handle
	 */

	public function handleLoadInputs(string $file): void
	{
		$presenter = $this->presenter;

		try {
			$inputs = [];

			if (isset($this['form']['component'])) {
				foreach ($this['form']['component']->getComponents() as $v) {
					$this['form']['component']->removeComponent($this['form']['component'][$v->getName()]);
				}
			}

			$tmp = explode('|', $file);
			if (count($tmp) == 2) {
				$this->templateReader->setTemplatesDir($this->pathsService->getTemplatePagesDir($tmp[0]));
				$file = $tmp[1];
			}

			if ($this->entity) {
				$texts = $this->entity->getTexts();
				$texts = is_array($texts) ? $texts : $texts->toArray();
			} else {
				$texts = [];
			}

			$this->templateReader->loadTemplateComponents($this['form']['component'], $file, $texts);
			if ($this->entity && property_exists($this->entity, 'template')) {
				$this->templateReader->setDefaults($this['form']['component'], $this->entity, $this->entity->template, $file);
			}

			$presenter->payload->inputs = $inputs;
			$presenter->flashMessageSuccess('default.loaded');
		} catch (\Exception $e) {
			$presenter->flashMessageDanger('default.error');
		}

		$this->selectedTemplate = $file;
		$this->redrawControl('component');
		$presenter->redrawControl('flashes');
	}
}
