<?php declare(strict_types = 1);

namespace Core\Model\Templating\Filters;

class YoutubeId
{
	public function __invoke(string $url): ?string
	{
		preg_match("/^(?:http(?:s)?:\/\/)?(?:www\.)?(?:m\.)?(?:youtu\.be\/|youtube\.com\/(?:(?:watch)?\?(?:.*&)?v(?:i)?=|(?:embed|v|vi|user)\/))([^\?&\"'>]+)/", $url, $matches);

		return $matches[1] ?? null;
	}
}
