<?php declare(strict_types = 1);

namespace Core\Model\Templating\Macros;

use Core\Model\Helpers\Strings;
use Latte\Compiler;
use Latte\MacroNode;
use Latte\Macros\MacroSet;
use Latte\PhpWriter;

final class Macros extends MacroSet
{
	public static function install(Compiler $compiler): void
	{
		$self = new self($compiler);
		$self->addMacro('css', [$self, 'macroCss']);
		$self->addMacro('js', [$self, 'macroJs']);
		$self->addMacro('fgc', [$self, 'macroFGC']);
		$self->addMacro('svg', [$self, 'macroSvg']);
	}

	public function macroCss(MacroNode $node, PhpWriter $writer): string
	{
		$arr   = TemplateText::parseInputAttrs($node->args);
		$media = null;

		if (empty($arr)) {
			$path = addslashes(ASSETS_DIR . '/' . $node->args);
			$file = str_replace(WWW_DIR, '', ASSETS_DIR) . '/' . $node->args;
		} else {
			$file = str_replace(WWW_DIR, '', ASSETS_DIR) . '/' . $arr['file'];
			if ($arr['media']) {
				$media = $arr['media'];
			}
		}

		if (!Strings::contains($file, '$') && !file_exists(WWW_DIR . $file)) {
			return '';
		}

		$str = "echo \"<link rel='stylesheet'" . ($media ? " media='$media'" : "") . " href='$file?v=\" . BUILD_TIME . \"'/>\"";

		return $writer->write($str);
	}

	public function macroJs(MacroNode $node, PhpWriter $writer): string
	{
		$path = addslashes(ASSETS_DIR . '/' . $node->args);
		$args = explode(', ', $node->args);

		$isAsync = in_array('async', $args);
		$isDefer = in_array('defer', $args);

		$file = str_replace(WWW_DIR, '', ASSETS_DIR) . '/' . $args[0];

		if (!Strings::contains($file, '$') && !file_exists(WWW_DIR . $file)) {
			return '';
		}

		$str = "echo \"<script src='$file?v=\" . BUILD_TIME .\"'" . (($isAsync ? ' async' : '') . ($isDefer ? ' defer' : '')) . "></script>\"";

		return $writer->write($str);
	}

	public function macroFGC(MacroNode $node, PhpWriter $writer): string
	{
		$file = trim($node->args, " '");
		if ($file[0] !== '$') {
			$file = "'$file'";
		}

		$str = "echo @file_get_contents(WWW_DIR . " . $file . ')';

		return $writer->write($str);
	}

	public function macroSvg(MacroNode $node, PhpWriter $writer): string
	{
		$arguments  = TemplateText::parseInputAttrs($node->args);
		$pathPrefix = isset($arguments['package']) ? SRC_DIR . '/' . $arguments['package'] . '/assets' : ASSETS_DIR;
		$content    = file_get_contents($pathPrefix . '/' . ltrim($arguments['src'], '/'));
		$str        = "echo '" . $content . "'";

		return $writer->write($str);
	}
}
