<?php declare(strict_types = 1);

namespace Core\Model\UI\DataGrid\Filter;

use Core\Model\UI\Form\BaseContainer;
use Nette\Forms\Controls\BaseControl;
use Ublaboo\DataGrid\DataGrid;
use Ublaboo\DataGrid\Filter\Filter;

class FilterCheckboxNestedList extends Filter
{
	/** @var string */
	protected $template = 'datagrid_filter_checkbox_nested_list.latte';

	/** @var string */
	protected $type = 'radioNestedList';

	protected bool  $enableSelectOne = false;
	protected array $flatItems       = [];

	public function __construct(DataGrid $grid, string $key, string $name, array $flatItems)
	{
		parent::__construct($grid, $key, $name);

		$this->flatItems = $flatItems;
	}

	public function setFlatItems(array $items): void
	{
		$this->flatItems = $items;
	}

	public function addToFormContainer(BaseContainer $container): void
	{
		$control = $container->addCheckboxNestedList($this->key, $this->name, $this->flatItems);

		$control->enableSelectOne($this->enableSelectOne);

		$this->addAttributes($control);
	}

	public function enableSelectOne(bool $val = true): self
	{
		$this->enableSelectOne = $val;

		return $this;
	}

	protected function addAttributes(BaseControl $input): BaseControl
	{
		if ($this->grid->hasAutoSubmit()) {
			$input->setHtmlAttribute('data-autosubmit', true);
		} else {
			$input->setHtmlAttribute('data-datagrid-manualsubmit', true);
		}

		foreach ($this->attributes as $key => $value) {
			if (is_array($value)) {
				$value = array_unique($value);
				$value = implode(' ', $value);
			}

			$input->setHtmlAttribute($key, $value);
		}

		return $input;
	}

	public function getCondition(): array
	{
		return [];
	}
}
