<?php declare(strict_types = 1);

namespace Core\Model\UI\DataGrid\Filter;

use Core\Model\UI\Form\BaseContainer;
use Core\Model\UI\Form\Controls\RadioNestedInput;
use Nette\Forms\Controls\BaseControl;
use Ublaboo\DataGrid\DataGrid;
use Ublaboo\DataGrid\Filter\Filter;
use Nette;

class FilterRadioNestedList extends Filter
{
	/** @var string */
	protected $template = 'datagrid_filter_radio_nested_list.latte';

	/** @var string */
	protected $type = 'radioNestedList';

	protected array $flatItems = [];

	public function __construct(DataGrid $grid, string $key, string $name, array $flatItems)
	{
		parent::__construct($grid, $key, $name);

		$this->flatItems = $flatItems;
	}

	public function getCondition(): array
	{
		return [];
	}

	public function addToFormContainer(BaseContainer $container): void
	{
		$control = $container->addRadioNestedList($this->key, $this->name, $this->flatItems);
		$control->setViewType(RadioNestedInput::VIEW_TYPE_COMPACT);

		$this->addAttributes($control);
	}

	protected function addAttributes(BaseControl $input): Nette\Forms\Controls\BaseControl
	{
		if ($this->grid->hasAutoSubmit()) {
			$input->setHtmlAttribute('data-autosubmit', true);
		} else {
			$input->setHtmlAttribute('data-datagrid-manualsubmit', true);
		}

		foreach ($this->attributes as $key => $value) {
			if (is_array($value)) {
				$value = array_unique($value);
				$value = implode(' ', $value);
			}

			$input->setHtmlAttribute($key, $value);
		}

		return $input;
	}

}
