<?php declare(strict_types=1);

namespace Core\Model\UI\DataGrid\Traits;

use Nette\Utils\Html;
use Ublaboo\DataGrid\DataGrid;

trait TButtonTryAddIcon
{

	public function tryAddIcon(Html $el, ?string $iconString, string $name): void
	{
		if ($iconString !== null) {
			$iconClass = '';

			if (strpos($iconString, 'fas') === 0) {
				$iconClass = $iconString;
			} else {
				foreach (explode(' ', $iconString) as $icon) {
					$iconClass .= ' ' . DataGrid::$iconPrefix . $icon;
				}
			}

			$el->addHtml(Html::el('span')->setAttribute('class', trim($iconClass)));
		}
	}
}
