<?php declare(strict_types = 1);

namespace Core\Model\UI\Form\Controls;

use Core\Model\Lang\ILang;
use Core\Model\Lang\Langs;

class LangsSelectInput extends SelectInput
{
	protected Langs $langsService;
	protected bool  $allowAllLang = true;

	/**
	 * @param string|object $label
	 */
	public function __construct($label, Langs $langs)
	{
		$this->langsService = $langs;
		$items              = ['' => 'default.all'];

		foreach ($langs->getLangs() as $lang) {
			if ($lang instanceof ILang) {
				$items[$lang->getTag()] = $lang->getTitle();
			}
		}

		parent::__construct($label, $items);

		$this->setDefaultValue($langs->getLang()->getTag());
	}

	public function allowAllLang(bool $allow = true): self
	{
		$this->allowAllLang = $allow;

		return $this;
	}

	public function setItems(array $items, bool $useKeys = true): self
	{
		if ($items) {
			parent::setItems($items, $useKeys);
		} else {
			$items = $this->allowAllLang ? ['' => 'default.all'] : [];
			$langs = $this->langsService;

			foreach ($langs->getLangs() as $lang) {
				if ($lang instanceof ILang) {
					$items[$lang->getTag()] = $lang->getTitle();
				}
			}

			parent::setItems($items);
			$this->setDefaultValue($langs->getLang()->getTag());
		}

		return $this;
	}

	/*******************************************************************************************************************
	 * ======================== REGISTER
	 */

	public static function register(\Nette\DI\Container $systemContainer): void
	{
		$class = __CLASS__;
		\Nette\Forms\Container::extensionMethod('addLangsSelect', static function(
			\Nette\Forms\Container $container, $name, $caption
		) use ($class, $systemContainer) {
			/** @var LangsSelectInput $comp */
			$comp = new $class($caption, $systemContainer->getService('langs'));

			$container->addComponent($comp, $name);

			return $comp;
		});
	}
}
