<?php declare(strict_types = 1);

namespace Core\Model\UI\Form\Controls;

use Core\Model\UI\Form\BaseForm;
use Core\Model\UI\Form\Traits\ChoiceInputTraitMulti;
use Core\Model\UI\Form\Traits\InputPromptTrait;
use Core\Model\UI\Form\Traits\TInputExtend;
use Nette\Forms\Controls\MultiSelectBox;
use Nette\Utils\Html;

/**
 * @method BaseForm getForm(bool $throw = true)
 */
class MultiselectInput extends MultiSelectBox
{
	use ChoiceInputTraitMulti;
	use InputPromptTrait;
	use TInputExtend;

	/**
	 * @param string|object $label
	 */
	public function __construct($label = null, array $items = null)
	{
		parent::__construct($label, null);
		$this->setItems($items);
	}

	public function getControl(): Html
	{
		$select = parent::getControl()->setHtml('');

		$select->attrs += [
			'class'    => 'form-control',
			'disabled' => $this->isControlDisabled(),
		];
		$options       = $this->rawItems;

		if (!empty($this->prompt)) {
			$options = [null => $this->prompt] + $options;
		}

		$optList = $this->makeOptionList($options, function($value) {
			return [
				'selected' => $this->isValueSelected($value),
				'disabled' => $this->isValueDisabled($value),
			];
		});

		foreach ($optList as $item) {
			$select->addHtml($item);
		}

		return $select;
	}
}
