<?php declare(strict_types = 1);

namespace Core\Model\UI\Form\Controls;

use Core\Model\SystemConfig;
use Core\Model\UI\Form\BaseForm;
use libphonenumber\NumberParseException;
use libphonenumber\PhoneNumber;
use libphonenumber\PhoneNumberUtil;
use Nette\Forms\IControl;

class PhoneInput extends TextInput
{
	protected bool $enableValidation = true;
	public const PHONE = 'Core\Model\UI\Form\Controls\PhoneInput::validatePhone';
	public static string $phoneMessages = 'default.formMessages.phone';

	/**
	 * @param string|object $label
	 */
	public function __construct($label = null)
	{
		parent::__construct($label, null);

		$this->control->type = 'tel';
		$this->setOption('type', 'tel');

		$this->setPlaceholder('123456789');
	}

	public function validate(): void
	{
		if (!$this->enableValidation) {
			return;
		}

		$this->addCondition(BaseForm::FILLED)
			->addRule(BaseForm::PATTERN, 'default.formMessages.phone_min', '(.*\d.*){9}');

		parent::validate();
	}

	public static function validatePhone(IControl $control, ?array $regions = null): bool
	{
		$valid = false;

		if (!$regions) {
			$regions = SystemConfig::load('phoneInputRegions');
		}
		$phoneUtil = PhoneNumberUtil::getInstance();

		try {
			foreach ($regions as $region) {
				/** @var PhoneNumber $phoneParsed */
				$phoneParsed = $phoneUtil->parse($control->getValue(), $region);
				$valid       = $phoneUtil->isValidNumber($phoneParsed);

				if ($valid) {
					break;
				}
			}
		} catch (NumberParseException $e) {
			$valid = false;
		}

		return $valid;
	}

	public function enableValidation(bool $val = true): self
	{
		$this->enableValidation = $val;

		return $this;
	}
}
