<?php declare(strict_types = 1);

namespace Core\Model\UI\Form\Controls;

use Nette\Utils\Html;

/**
 * Class SortableCheckboxList
 * @package Core\Model\UI\Form\Controls
 */
class SortableCheckboxList extends CheckboxListInput
{
	public function getControl(): Html
	{
		parent::getControl();
		$fieldset = Html::el('div class=sortable-checkbox-list');

		$items = $this->items;

		// Defaults
		if ($this->value) {
			foreach (array_reverse($this->value) as $k) {
				if (!isset($items[$k])) {
					continue;
				}

				$value = $items[$k];
				unset($items[$k]);
				$items = [$k => $value] + $items;
			}
		}

		foreach ($items as $value => $caption) {
			$line = CheckboxInput::makeCheckbox($this->getHtmlName(), $caption, $this->isValueSelected($value),
				$value, false, $this->isValueDisabled($value), $this->getHtmlId((string) $value));

			$fieldset->addHtml(Html::el('div class=item data-active=' . ($this->isValueSelected($value) ? '1' : '0'))->addHtml('<div class="icon"><i class="fas fa-sort"></i></div>')->addHtml($line));
		}

		return $fieldset;
	}
}
