<?php declare(strict_types = 1);

namespace Core\Model\UI\Form\Controls;

use Nette\Forms\Controls\UploadControl;
use Nette\Utils\Html;

class UploadInput extends UploadControl
{
	public function getControl()
	{
		$control        = parent::getControl();

		if ($control instanceof Html) {
			$control->addClass('custom-file-input');
		}

		$el = Html::el('label', ['class' => 'custom-file']);
		$el->addHtml($control);
		$el->addHtml(
			Html::el('span', ['class' => 'custom-file-control'])
		);

		$wrapper = Html::el();
		$wrapper->addHtml($el);

		if ($this->getValue()) {
			$wrapper->addHtml(Html::el('img', ['src' => $this->getValue(), 'class' => 'img-thumbnail']));
		}

		return $wrapper;
	}
}
