<?php declare(strict_types = 1);

namespace Core\Model\UI\Form\Traits;

use Nette\Utils\Html;

/**
 * @property string $btnType
 */
trait BootstrapButtonTrait
{
	protected string $btnClass = 'btn-primary';

	protected bool $floating = false;

	public function getBtnClass(): string { return $this->btnClass; }

	public function setBtnClass(string $btnClass): self
	{
		$this->btnClass = $btnClass;

		return $this;
	}

	public function setFloating(bool $value = true): self
	{
		$this->floating = $value;

		return $this;
	}

	public function getControl(?string $caption = null): Html
	{
		$control = parent::getControl($caption);
		$this->addBtnClass($control);
		$control->setName('button')->addHtml('<span>' . $this->translate($caption ?? $this->caption) . '</span>');

		if ($this->floating) {
			return Html::el('div', ['class' => 'floating-submit'])->setHtml($control);
		}

		return $control;
	}

	protected function addBtnClass(Html $element): self
	{
		$element->addClass('btn ' . $this->getBtnClass());

		return $this;
	}
}
