<?php declare(strict_types = 1);

namespace Core\Model\UI;

use Core\Components\Navigation\DaoNavigationItem;
use Core\Model\Event\ControlEvent;
use Core\Model\Http\TextResponse;
use Core\Model\UI\Traits\TPresenterComponentPack;
use Nette\Application\UI\Template;
use Nette\Utils\Arrays;

abstract class FrontPresenter extends AbstractPresenter
{
	use TPresenterComponentPack;

	public array                 $breadcrumbsBefore = [];
	public array                 $breadcrumbsAfter  = [];
	protected ?DaoNavigationItem $activeNavigation  = null;

	protected function startup()
	{
		$this->eventDispatcher->dispatch(new ControlEvent($this), self::class . '::startup');
		parent::startup();
	}

	public function beforeRender()
	{
		$this->componentsPack['bodyEnd'][] = $this['jsTranslates'];
		$this->eventDispatcher->dispatch(new ControlEvent($this), self::class . '::beforeRender');
		parent::beforeRender();
	}

	public function sendTemplate(?Template $template = null): void
	{
		if ($this->isAjax()) {
			parent::sendTemplate($template);
		}

		$template = $template ?? $this->getTemplate();
		if (!$template->getFile()) {
			$files        = $this->formatTemplateFiles();
			$templateFile = null;
			foreach ($files as $file) {
				if (is_file($file)) {
					$templateFile = $file;
					break;
				}
			}

			if ($templateFile) {
				$template->setFile($templateFile);
			} else {
				$templateFile = strtr(Arrays::first($files), '/', DIRECTORY_SEPARATOR);
				$this->error("Page not found. Missing template '$templateFile'.");
			}
		}

		$this->sendResponse(new TextResponse($template));
	}

	public function handleMeasuringCodesTurnOn(): void
	{
		$this->redrawControl('components-pack-bodyStart');
		$this->redrawControl('components-pack-bodyEnd');
	}

	public function link(string $destination, $args = []): string
	{
		$activeNavigation = $this->getActiveNavigation();

		if ($activeNavigation && is_array($args) && !empty($args) && !array_key_exists(0, $args) && !array_key_exists('activeNavigation', $args)) {
			$args['activeNavigation'] = $activeNavigation;
		}

		return parent::link($destination, $args);
	}

	public function sendJson($data): void
	{
		if (is_array($data)
			&& !array_key_exists('requestKey', $data)
			&& $this->getParameter('requestKey')
		) {
			$data['requestKey'] = $this->getParameter('requestKey');
		}

		parent::sendJson($data);
	}

	public function getActiveNavigation(): ?DaoNavigationItem { return $this->activeNavigation; }

	public function setActiveNavigation(DaoNavigationItem $item): void { $this->activeNavigation = $item; }
}
