<?php declare(strict_types = 1);

namespace Core\Model;

class WebColors
{
	protected Settings $settings;

	public function __construct(Settings $settings)
	{
		$this->settings = $settings;
	}

	public function clearCache(): void
	{
		$this->settings->clearCache();
	}

	public function getColors(string $siteIdent = ''): array
	{
		$siteIdent = $siteIdent === '' ? $siteIdent : $siteIdent . '_';

		return $this->settings->getPrefixed($siteIdent . 'webColors') ?: [];
	}
}
