<?php

declare(strict_types = 1);

namespace Migrations;

use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Schema\Schema;
use Doctrine\Migrations\AbstractMigration;
use Tracy\Debugger;

/**
 * Auto-generated Migration: Please modify to your needs!
 */
class Version20220114212530 extends AbstractMigration
{
	public function getDescription(): string
	{
		return '';
	}

	public function up(Schema $schema): void
	{
		// this up() migration is auto-generated, please modify it to your needs
		$this->abortIf($this->connection->getDatabasePlatform()->getName() !== 'mysql', 'Migration can only be executed safely on \'mysql\'.');
	}

	public function postUp(Schema $schema): void
	{
		parent::postUp($schema);
		try {
			$this->connection->transactional(function(Connection $connection) {
				$count = $this->connection->fetchOne('SELECT COUNT(*) FROM `core__cookie_additional_service` WHERE `ident` = \'youtube\'');

				if ($count === 0) {
					$sites = $this->connection->fetchAll('SELECT `ident` FROM `core__site`');

					$this->connection->insert('core__cookie_additional_service', [
						'ident' => 'youtube',
						'name' => 'YouTube',
					]);

					$serviceId = $this->connection->lastInsertId();

					foreach ($sites as $site) {
						$this->connection->insert('core__cookie_additional_service_in_site', [
							'cookie_additional_service_id' => $serviceId,
							'site_id' => $site['ident']
						]);
					}
				}
			});
		} catch ( \Exception $exception ) {
			Debugger::log($exception);
		}
	}

	public function down(Schema $schema): void
	{
		// this down() migration is auto-generated, please modify it to your needs
		$this->abortIf($this->connection->getDatabasePlatform()->getName() !== 'mysql', 'Migration can only be executed safely on \'mysql\'.');

		$this->addSql('DELETE FROM `core__cookie_additional_service` WHERE `ident` =  `youtube`');
	}
}