<?php declare(strict_types = 1);

namespace Core\Model\Pdf;

use Mpdf\Mpdf;
use Nette\Application\UI\ITemplateFactory;

class Pdf
{
	/** @var array */
	protected $mPdfConfigDefaults = [
		'tempDir' => TMP_DIR . '/mPdf',
	];

	/** @var array */
	protected $mPdfConfig;

	/** @var ITemplateFactory */
	protected $templateFactory;

	public function __construct($mPdfConfig, ITemplateFactory $templateFactory)
	{
		$this->mPdfConfig      = array_merge($this->mPdfConfigDefaults, $mPdfConfig);
		$this->templateFactory = $templateFactory;
	}

	public function newPdf()
	{
		if (isset($this->mPdfConfig['fontDir'])) {
			$defaultConfig = (new \Mpdf\Config\ConfigVariables())->getDefaults();
			$fontDirs      = $defaultConfig['fontDir'];

			$this->mPdfConfig['fontDir'] = array_merge($fontDirs, $this->mPdfConfig['fontDir']);
		}

		if (isset($this->mPdfConfig['fontData'])) {
			$defaultFontConfig = (new \Mpdf\Config\FontVariables())->getDefaults();
			$fontData          = $defaultFontConfig['fontdata'];

			$this->mPdfConfig['fontData'] = $fontData + $this->mPdfConfig['fontData'];
		}

		$mpdf = new Mpdf($this->mPdfConfig);

		return $mpdf;
	}

	public function getTemplateFactory()
	{
		$latte = $this->templateFactory->createTemplate();

		return $latte;
	}
}