import SimpleBar from 'simplebar';
import naja from "naja";
import {Utilities} from "core/front/src/js/utils/utilities";

naja.historyHandler.uiCache = false;
naja.history = false;
naja.uiHandler.selector = '';
window.naja = naja;

// TODO staré řešení JS volá metodu v ajaxComplete. Při předělávání nezapomenou se napojit na najaComplete
window.fileRequest = (fileRequests) => {
	if (fileRequests === undefined)
		return;

	for (let i in fileRequests) {
		window.open(fileRequests[i].url, fileRequests[i].name);
	}
};

naja.addEventListener('before', e => {
	let loadingOverlay = document.getElementById('loading-overlay');

	if (loadingOverlay !== null) {
		loadingOverlay.dataset.count = parseInt(loadingOverlay.dataset.count) + 1;
	} else {
		document.getElementsByTagName('BODY')[0].insertAdjacentHTML('beforeend', '<div id="loading-overlay" data-count="1">' +
			'<div class="spinner">' +
			'<div class="rect1"></div>' +
			'<div class="rect2"></div>' +
			'<div class="rect3"></div>' +
			'<div class="rect4"></div>' +
			'<div class="rect5"></div>' +
			'</div></div>');
	}
});

naja.addEventListener('complete', e => {
	let loadingOverlay = document.getElementById('loading-overlay');

	if (loadingOverlay) {
		if (loadingOverlay.dataset.count > 1)
			loadingOverlay.dataset.count = parseInt(loadingOverlay.dataset.count) - 1;
		else
			loadingOverlay.parentNode.removeChild(loadingOverlay);
	}
});

document.addEventListener('DOMContentLoaded', () => {
	document.querySelectorAll('[data-simplebar]').forEach(el => {
		new SimpleBar(el);
	});

	initBoolSwitcherControl();

	// Kvůli kompatibilitě s jquery
	window.jQuery(document).ajaxComplete(function (event, xhr, settings) {
		initBoolSwitcherControl();
	});

	naja.addEventListener('complete', e => {
		initBoolSwitcherControl();
	});
});

// bool switcher
const initBoolSwitcherControl = () => {
	document.querySelectorAll('.bool-switcher-control label:not(.init)').forEach(label => {
		label.classList.add('init');
		label.addEventListener('click', e => {
			let siblings = Utilities.getSiblings(label);

			siblings.forEach(sib => {
				sib.setAttribute('class', 'btn btn-outline-' + sib.dataset.btnClass);
			});

			label.setAttribute('class', 'btn btn-' + label.dataset.btnClass);
		});
	});
};

