<?php declare(strict_types = 1);

namespace Core\FrontModule\Components\StructureData;

use Core\Model\UI\BaseControl;
use Spatie\SchemaOrg\BaseType;

class DataSchema extends BaseControl
{
	/** @var BaseType[] */
	private $schemas;

	public function render()
	{
		if (!$this->schemas)
			return '';
		$this->template->schemas = $this->schemas;
		$this->template->render(__DIR__ . "/DataSchema.latte");
	}

	public function addSchema($schema)
	{
		if ($schema instanceof BaseType === false)
			throw new \InvalidArgumentException();

		$this->schemas[] = $schema;
	}
}
