<?php declare(strict_types = 1);

namespace Core\Model\MathParser\Operator;

use Core\Model\MathParser\TerminalExpression;

abstract class Operator extends TerminalExpression
{
	protected $precidence = 0;
	protected $leftAssoc  = true;

	public function getPrecidence()
	{
		return $this->precidence;
	}

	public function isLeftAssoc()
	{
		return $this->leftAssoc;
	}

	public function isOperator()
	{
		return true;
	}
}