<?php declare(strict_types = 1);

namespace Core\Model\UI\Form\Controls;

use Core\Model\SystemConfig;
use Core\Model\UI\Form\BaseForm;
use libphonenumber\NumberParseException;
use libphonenumber\PhoneNumberUtil;
use Nette\Forms\IControl;

class PhoneInput extends TextInput
{
	protected $regionRuleIsSet = false;

	protected $region;

	const PHONE = 'Core\Model\UI\Form\Controls\PhoneInput::validatePhone';

	public static $phoneMessages = 'default.formMessages.phone';

	public function __construct($label = null)
	{
		parent::__construct($label, null);

		$this->control->type = 'tel';
		$this->setOption('type', 'tel');

		$this->setPlaceholder('123456789');
	}

	public function validate()
	{
		$this->addRule(BaseForm::PATTERN, 'default.formMessages.phone_min', '(.*\d.*){9}'); //pro JS validaci - minimalne 9 cislic

		return parent::validate();
	}


	public static function validatePhone(IControl $control, $regions = null)
	{
		$valid = false;

		if (!$regions)
			$regions = SystemConfig::load('phoneInputRegions');
		$phoneUtil = PhoneNumberUtil::getInstance();

		try {
			if (!is_array($regions))
				$regions = [$regions];

			foreach ($regions as $region) {
				$phoneParsed = $phoneUtil->parse($control->value, $region);
				$valid       = $phoneUtil->isValidNumber($phoneParsed);

				if ($valid)
					break;
			}
		} catch (NumberParseException $e) {
			$valid = false;
		}

		return $valid;
	}
}
