CKEDITOR.plugins.add('blocks', {
	requires: 'widget',

	init: function (editor) {
		var pluginName = 'Blocks';

		editor.widgets.add('block1', {
			requiredContent: 'div(ck-block-1)',
			template: '<div class="ck-block-1">' +
			'<div class="image"><img src="/images/default-placeholder.png" alt=""></div>' +
			'<div class="content">vložte text...</div>' +
			'</div>',
			button: 'Blok 1',
			editables: {
				image: {
					selector: '.image'
				},
				content: {
					selector: '.content'
				},
			},
			upcast: function (element) {
				return element.name == 'div' && element.hasClass('ck-block-1');
			}
		});

		editor.widgets.add('block2left', {
			requiredContent: 'div(ck-block-2-left)',
			template: '<div class="ck-block-2 ck-block-2-left">' +
			'<div class="image"><img src="/images/default-placeholder.png" alt=""></div>' +
			'<div class="content">vložte text...</div>' +
			'</div>',
			button: 'Blok 2 levo',
			editables: {
				image: {
					selector: '.image'
				},
				content: {
					selector: '.content'
				},
			},
			upcast: function (element) {
				return element.name == 'div' && element.hasClass('ck-block-2-left');
			}
		});

		editor.widgets.add('block2right', {
			requiredContent: 'div(ck-block-2-right)',
			template: '<div class="ck-block-2 ck-block-2-right">' +
			'<div class="image"><img src="/images/default-placeholder.png" alt=""></div>' +
			'<div class="content">vložte text...</div>' +
			'</div>',
			button: 'Blok 2 pravo',
			editables: {
				image: {
					selector: '.image'
				},
				content: {
					selector: '.content'
				},
			},
			upcast: function (element) {
				return element.name == 'div' && element.hasClass('ck-block-2-right');
			}
		});
	}
});
