<?php declare(strict_types = 1);

namespace Core\AdminModule\Model;

use Core\Model\Entities\Site;
use Core\Model\Helpers\BaseEntityService;

/**
 * Class Sites
 * @package Core\AdminModule\Model
 */
class Sites extends BaseEntityService
{
	protected $entityClass = Site::class;

	/**
	 * @param string $name
	 *
	 * @return Site|null
	 * @throws \Doctrine\ORM\NonUniqueResultException
	 */
	public function get(string $name): ?Site
	{
		return $this->getEr()->createQueryBuilder('s')
			->addSelect('st')
			->innerJoin('s.texts', 'st')
			->where('s.ident = :ident')
			->setParameter('ident', $name)
			->getQuery()->getOneOrNullResult();
	}

	/**
	 * @return Site[]
	 */
	public function getAll(): array
	{
		return $this->getEr()->createQueryBuilder('s')
			->addSelect('st')
			->innerJoin('s.texts', 'st')
			->getQuery()->getResult();
	}
}
