<?php declare(strict_types = 1);

namespace Core\AdminModule\Presenters;

use Core\AdminModule\Components\IDataFormFactory;
use Core\AdminModule\Components\Settings\ISiteFormFactory;
use Core\AdminModule\Components\Settings\IWebSettingsFormFactory;
use Core\AdminModule\Components\Settings\SiteForm;
use Core\AdminModule\Components\Settings\WebSettingsForm;
use Core\AdminModule\Model\Sites;
use Nette\Application\UI\Multiplier;

class SettingsPresenter extends BasePresenter
{
	/** @var Sites @inject */
	public $sitesService;

	protected function startup()
	{
		parent::startup();
		if (!$this->getUser()->isAllowed($this->getFullModuleName(), 'settings'))
			$this->error();

		$this->setHeader('admin.title.cmsSettings', 'fas fa-cogs');
	}

	/*******************************************************************************************************************
	 * ===============================  Render
	 */

	public function renderDefault(): void
	{
		$this->template->sites = $this->sitesService->getAll();
	}

	/*******************************************************************************************************************
	 * ===============================  Components
	 */

	protected function createComponentSiteForm(ISiteFormFactory $factory): Multiplier
	{
		return new Multiplier(function(string $ident) use ($factory) : SiteForm {
			$control = $factory->create($ident);

			return $control;
		});
	}

	protected function createComponentWebSettingsForm(IWebSettingsFormFactory $factory): Multiplier
	{
		return new Multiplier(function(string $ident) use ($factory) : WebSettingsForm {
			$control = $factory->create($ident);

			return $control;
		});
	}

	protected function createComponentGlobalDataForm(IDataFormFactory $factory)
	{
		return $factory->create('globalData');
	}
}
