<?php declare(strict_types = 1);

namespace Core\Model\Helpers;

use Nette\Forms\Container;
use Nette\Forms\Controls\SelectBox;
use Nette\Utils\ArrayHash;

class FormHelper
{
	public static function fillContainerByEntity(Container &$container, $entity): void
	{
		foreach ($container->getComponents() as $input) {
			$name = $input->getName();

			if (!isset($entity->$name))
				continue;

			if ($input instanceof SelectBox) {
				if (array_key_exists($entity->$name, $input->getItems()))
					$input->setDefaultValue($entity->$name);
			} else {
				$input->setDefaultValue($entity->$name);
			}
		}
	}

	public static function fillEntityByValues(&$entity, $values): void
	{
		foreach ($values as $k => $v) {
			if (!property_exists($entity, $k))
				continue;

			$entity->$k = $v;
		}
	}
}
