<?php declare(strict_types = 1);

namespace Core\Model\Images;

use Nette\Utils\Image as NImage;
use Nette\Utils\UnknownImageFileException;

class ImageHelper
{
	/**
	 * @param string $file
	 * @param mixed  $width
	 * @param mixed  $height
	 * @param int    $flags
	 *
	 * @return string
	 * @throws UnknownImageFileException
	 */
	public static function createBase64Miniature(string $file, $width, $height, $flags = NImage::FIT): string
	{
		$image = NImage::fromFile($file);
		$image->resize($width, $height, $flags);

		$type   = pathinfo($file, PATHINFO_EXTENSION);
		$base64 = base64_encode((string) $image);

		return sprintf('data:image/%s;base64,%s', $type, $base64);
	}
}
