<?php declare(strict_types = 1);

namespace Core\Model\Mailing;

use Core\Model\Settings;
use Nette\Mail\IMailer;
use Nette\Mail\SmtpMailer;

class MailBuilderFactory
{
	/** @var Settings */
	protected $settings;

	/** @var IMailer */
	protected $sender;

	/** @var TemplateFactory */
	protected $templateFactory;

	/** @var array */
	protected $config;

	/**
	 * MailBuilderFactory constructor.
	 *
	 * @param array           $config
	 * @param Settings        $settings
	 * @param IMailer         $sender
	 * @param TemplateFactory $templateFactory
	 */
	public function __construct($config, Settings $settings, IMailer $sender, TemplateFactory $templateFactory)
	{
		$this->config              = $config;
		$this->config['siteName']  = $settings->get('siteName');
		$this->config['siteEmail'] = $settings->get('siteEmail');

		$this->sender          = isset($config['smtp']) ? new SmtpMailer($config['smtp']) : $sender;
		$this->templateFactory = $templateFactory;
	}

	public function getConfig(): array { return $this->config; }

	/**
	 * @return MailBuilder
	 */
	public function create()
	{
		$mail = new MailBuilder($this->sender);
		$mail->setTemplate($this->templateFactory->create());

		return $mail;
	}
}
