const path = require('path');
const config = require('./admin.config');
const ExtractTextPlugin = require('extract-text-webpack-plugin');
const LiveReloadPlugin = require('webpack-livereload-plugin');
const MiniCssExtractPlugin = require('mini-css-extract-plugin');
const WebpackMessages = require('webpack-messages');
const webpack = require("webpack");
const autoprefixer = require('autoprefixer');
const CopyPlugin = require('copy-webpack-plugin');

module.exports = {
	// Odkaz na node_moduly v core
	stats: 'minimal',
	resolve: {
		alias: config.aliases
	},
	// Definice vstupnich souboru
	entry: config.entry,
	optimization: {
		splitChunks: {
			cacheGroups: {
				commons: {
					name: 'libs',
					chunks: 'initial',
					minChunks: 2
				}
			}
		}
	},
	//Definice výstupních cest
	output: {
		path: path.join(__dirname, '../../../www/assets/admin'),
		filename: 'js/[name].js'
	},
	plugins: [
		new MiniCssExtractPlugin({filename: '_css/[name].css'}),
		new LiveReloadPlugin(),
		new WebpackMessages({
			name: 'Admin package',
			logger: str => console.log(`ADMIN ASSETS BUNDLER >> ${str}`)
		}),
		new webpack.ProvidePlugin({
			$: 'jquery',
			jQuery: 'jquery',
			'window.jquery': 'jquery'
		}),
		new CopyPlugin([
			{
				from: 'vendor/pshkcms/core/assets/default',
				to: 'default',
				context: ''
			},
			{
				from: 'vendor/pshkcms/core/assets/el-finder',
				to: 'el-finder',
				context: ''
			},
			{
				from: 'vendor/pshkcms/core/assets/img',
				to: 'img',
				context: ''
			},
			{
				from: 'vendor/pshkcms/core/assets/shared',
				to: 'shared',
				context: ''
			},
			{
				from: 'vendor/pshkcms/core/assets/admin/fonts',
				to: 'fonts',
				context: ''
			}
		]),
	],
	module: {
		rules: [
			{
				test: /\.m?js$/,
				exclude: /(node_modules|bower_components)/,
				use: {
					loader: 'babel-loader',
					options: {
						cacheDirectory: path.join(__dirname, '../../../www/assets/cache'),
						presets: [
							[
								"@babel/preset-env",
								{
									corejs: '3.0.0',
									// "useBuiltIns": "usage"
								}
							]
						],
					}
				}
			},
			{
				test: /\.(sa|sc|c)ss$/,
				use: [
					{
						loader: MiniCssExtractPlugin.loader,
						options: {
							sourceMap: true
						}
					},
					{
						loader: 'css-loader?-url', options: {
							sourceMap: true
						}
					},
					{
						loader: 'sass-loader', options: {
							sourceMap: true
						}
					}
				],
			}
		]
	}
};
