import $ from 'jquery';

export class Utilities {
	static getSiblings(elem) {
		let siblings = [];
		let sibling = elem.parentNode.firstChild;

		while (sibling) {
			if (sibling.nodeType === 1 && sibling !== elem) {
				siblings.push(sibling);
			}
			sibling = sibling.nextSibling
		}

		return siblings;
	};

	static parentsContainClass(el, q, maxParents) {
		let parent = el;
		for (let i = 1; i <= maxParents; i++) {
			parent = parent.parentNode;

			if (parent && parent.classList.contains(q)) {
				return parent;
			}
		}

		return false;
	}

	static pathContainClass(path, q) {
		for (let i in path) {
			let el = path[i];

			if (el.classList.contains(q)) {
				return el;
			}
		}

		return null;
	}

	static toggleClass(element, className) {
		if (element.classList.contains(className))
			return element.classList.remove(className);
		return element.classList.add(className);

	}
}

export const scrollTo = (amount, speed = 1000) => {
	const body = $("html, body");
	body.stop().animate({scrollTop: amount}, 1000, 'swing', function () {
	});
};

export function responsive(func) {
	func();
	$(window).on('resize', function () {
		func();
	})
}

export function checkMedia(mediaWith, maxmin = "max") {
	return window.matchMedia('(' + maxmin + '-width: ' + mediaWith + 'px)').matches;
}

export function responsiveOnMedia(onMediaEnter, onMediaExit, mediaWith, maxmin = "max") {
	if (checkMedia(mediaWith, maxmin)) onMediaEnter();
	$(window).on('resize', function () {
		if (checkMedia(mediaWith, maxmin)) onMediaEnter();
		else onMediaExit();
	})
}

export function convertRemToPixels(rem) {
	return rem * parseFloat(getComputedStyle(document.documentElement).fontSize);
}

export function arrayRemove(arr, value) {
	return arr.filter((el) => {
		return el != value;
	});
}
