<?php declare(strict_types = 1);

namespace Core\Model\Entities;

use Nettrine\ORM\EntityManagerDecorator as NettrineEM;

class EntityManagerDecorator extends NettrineEM
{
	public function clear($objectName = null)
	{
		if (is_array($objectName))
			foreach ($objectName as $obj)
				parent::clear($obj);
		else
			parent::clear($objectName);
	}

	public function persist($object): self
	{
		parent::persist($object);

		return $this;
	}

	public function createQueryBuilder()
	{
		return new QueryBuilder($this);
	}

}
