<?php declare(strict_types = 1);

namespace Core\Model\Entities;

use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Table(name="core__extra_field")
 * @ORM\Entity
 */
class ExtraField
{

	/**
	 * @var string
	 * @ORM\Id
	 * @ORM\Column(name="section_name", type="string", length=255, nullable=false)
	 */
	public $sectionName;

	/**
	 * @var string
	 * @ORM\Id
	 * @ORM\Column(name="section_key", type="string", length=255, nullable=false)
	 */
	public $sectionKey;

	/**
	 * @var string
	 * @ORM\Id
	 * @ORM\Column(name="`key`", type="string", length=255, nullable=false)
	 */
	public $key;

	/**
	 * @var string
	 * @ORM\Column(name="value", type="text", nullable=true)
	 */
	public $value;

	public function __construct(string $key, $value = null)
	{
		$this->key   = $key;
		$this->value = $value;
	}
}
