<?php declare(strict_types = 1);

namespace Core\Model\Lang;

use Nette\Localization\ITranslator;

/**
 * Class Langs
 * @package Core\Model\Lang
 */
class Langs
{
	/** @var ITranslator */
	protected $translator;

	/** @var Lang[] */
	protected $langs;

	public function setTranslator(ITranslator $translator)
	{
		$this->translator = $translator;

		$this->langs['default'] = new Lang(
			$translator->translate('lang.title'),
			$translator->translate('lang.shortTitle'),
			$translator->translate('lang.tag'),
			$translator->translate('lang.fullTag')
		);

		foreach ($translator->getLocalesWhitelist() as $locale) {
			$lang                         = new Lang(
				$translator->trans('title', [], 'lang', $locale),
				$translator->trans('shortTitle', [], 'lang', $locale),
				$translator->trans('tag', [], 'lang', $locale),
				$translator->trans('fullTag', [], 'lang', $locale)
			);
			$this->langs[$lang->getTag()] = $lang;
		}
	}

	/**
	 * @param $locale
	 *
	 * @return Lang
	 */
	public function getLang($locale = 'default')
	{
		return $this->langs[$locale] ?? $this->langs['default'];
	}

	/**
	 * @return Lang[]
	 */
	public function getLangs($withDefault = true)
	{
		$tmp = $this->langs;

		if (!$withDefault)
			unset($tmp['default']);

		return $tmp;
	}

	public function setDefault(string $key): self
	{
		$this->langs['default'] = $this->getLang($key);

		return $this;
	}
}
