<?php declare(strict_types = 1);

namespace Core\Model\Router;

use Nette\Http\UrlScript;
use Nette\Http\IRequest;

class RouteAdmin extends Route
{
	protected $module = 'admin';

	public function setModule($module)
	{
		$this->module = $module;

		return $this;
	}

	public function match(IRequest $httpRequest): ?array
	{
		$match = parent::match($httpRequest);

		if ($match && strpos($match['presenter'], ':' . ucfirst($this->module) . ':') === false) {
			$name = explode(':', $match['presenter']);
			array_splice($name, 1, 0, ucfirst($this->module));
			$match['presenter'] = implode(':', $name);
		}

		return $match;
	}

	public function constructUrl(array $params, UrlScript $refUrl): ?string
	{
		if (strpos($params['presenter'], ':' . ucfirst($this->module) . ':') === false)
			return null;

		$url = parent::constructUrl($params, $refUrl);
		$url = str_replace('.' . strtolower($this->module), '', $url);

		return $url;
	}
}
