<?php declare(strict_types = 1);

namespace Core\Model\UI\Form\Controls;

use Core\Model\UI\Form\Traits\ChoiceInputTrait;
use Core\Model\UI\Form\Traits\InputPromptTrait;
use Core\Model\UI\Form\Traits\TInputExtend;
use Nette\Forms\Controls\MultiSelectBox;
use Nette\Utils\Html;

class MultiselectInput extends MultiSelectBox
{
	use ChoiceInputTrait;
	use InputPromptTrait;
	use TInputExtend;

	public function __construct($label = null, array $items = null)
	{
		parent::__construct($label, null);
		$this->setItems($items);
	}

	public function getControl(): Html
	{
		$select = parent::getControl()->setHtml(null);

		$select->attrs += [
			'class'    => 'form-control',
			'disabled' => $this->isControlDisabled(),
		];
		$options       = $this->rawItems;
		if (!empty($this->prompt)) {
			$options = [null => $this->prompt] + $options;
		}

		$optList = $this->makeOptionList($options, function($value) {
			return [
				'selected' => $this->isValueSelected($value),
				'disabled' => $this->isValueDisabled($value),
			];
		});
		foreach ($optList as $item) {
			$select->addHtml($item);
		}

		return $select;
	}
}
