<?php declare(strict_types = 1);

namespace Core\Model\UI\Form\Controls;

use Core\Model\UI\Form\Traits\TInputExtend;
use Core\Model\UI\Form\Traits\TTextBase;
use Nette\Utils\Strings;

/**
 * Class TextInput
 * @property string $placeholder
 * @package Czubehead\BootstrapForms\Inputs
 */
class TextInput extends \Nette\Forms\Controls\TextInput
{
	use TInputExtend;
	use TTextBase;

	/**
	 * @var string
	 */
	private $placeholder;

	/*
	 * @inheritdoc
	 */
	public function __construct($label = null, $maxLength = null)
	{
		parent::__construct($label, $maxLength);
		$this->setRequired(false);
	}

	/**
	 * @return string
	 */
	public function getPlaceholder()
	{
		return $this->placeholder;
	}

	/**
	 * @param string $placeholder
	 *
	 * @return static
	 */
	public function setPlaceholder($placeholder)
	{
		if (is_array($placeholder))
			foreach ($placeholder as $k => $v)
				$this->placeholder[$k] = $this->translate($v);
		else
			$this->placeholder = $this->translate($placeholder);

		return $this;
	}
}
