export const DataTabsInit = () => {
	/**
	 * General tabs logic
	 * [data-tabs] => triggers the target
	 * [data-tabs-content] => Defines the target
	 * [data-tabs-group] => Sets target to the switching group
	 * [data-tabs-default] => Sets default target to be visible
	 */
	const tabs = document.querySelectorAll('[data-tabs]');
	tabs.forEach(el => {
		el.addEventListener('click', () => {
			const tabTarget        = el.dataset.tabs;
			const tabsContent      = document.querySelector(`[data-tabs-content="${tabTarget}"]`);
			const tabGroup         = tabsContent.dataset.tabsGroup;
			const tabGroupElements = document.querySelectorAll(`[data-tabs-group="${tabGroup}"]`);

			tabs.forEach((tab) => tab.classList.remove('active'));
			el.classList.add('active');
			tabGroupElements.forEach(el => el.style.display = 'none');
			tabsContent.style.display = 'block';
		});
	});

	const tabsContent = document.querySelectorAll(`[data-tabs-content]`).forEach(el => {
		el.style.display = 'none';
	});

	const defaultTabs = document.querySelectorAll('[data-tabs-default]').forEach(el => {
		const tabTarget           = el.dataset.tabs;
		const tabsContent         = document.querySelector(`[data-tabs-content="${tabTarget}"]`);
		tabsContent.style.display = 'block';
		tabsContent.classList.add('active');
		el.classList.add('active');
	});
};
