import PNotify      from 'pnotify/dist/es/PNotify';
import {checkMedia} from "./utilities";

export class Flashes {
	constructor(naja) {
		let snippetFlashes = document.getElementById('snippet--flashes');
		if (snippetFlashes.firstChild) {
			this.pushNotifyFromSnippet(snippetFlashes.innerHTML);
		}

		global.naja.snippetHandler.addEventListener('afterUpdate', e => {
			if (e.snippet.id === 'snippet--flashes') {
				try {
					this.pushNotifyFromSnippet(e.content);

					e.preventDefault();
				} catch (e) {
				}
			}
		});
	}

	pushNotifyFromSnippet(content) {
		let el       = document.createElement('div');
		el.innerHTML = content;

		for (let i in el.children) {
			let child = el.children[i];

			if (!child.dataset || !child.dataset.type)
				return true;

			this.pushNotifyFromHtmlEl(child);
		}
	}

	pushNotifyFromHtmlEl(el) {
		let type = el.dataset.type;
		let top  = 25;

		const cart = document.querySelector('.shop-header__cart');
		if (cart) {
			const bounding = cart.getBoundingClientRect();
			const isMobile = checkMedia(document.body.dataset.responsiveBarThreshold);
			top            = bounding.y + (isMobile ? 0 : window.scrollY) + bounding.height + 10;
		}

		document.querySelectorAll('.ui-pnotify').forEach(el => {
			top += el.getBoundingClientRect().height + 10;
		});

		if (type == 'danger' || type == 'warning')
			type = 'error';

		const PNotifyAlert = PNotify.alert({
			delay      : 3000,
			text       : el.innerHTML,
			textTrusted: true,
			type       : type,
			stack      : {
				dir1     : 'down',
				dir2     : 'left',
				firstpos1: top,
				firstpos2: 25,
			}
		});
		PNotifyAlert.on("click", () => {
			PNotifyAlert.close();
		});
	}
}
