<?php declare(strict_types = 1);

namespace Core\AdminModule\Presenters;

use Core\AdminModule\Components\Redirects\IRedirectsGridFactory;
use Core\AdminModule\Components\Redirects\IUploadFormFactory;
use Core\AdminModule\Components\Redirects\IValidateFormFactory;
use Core\AdminModule\Components\Redirects\RedirectsGrid;
use Core\AdminModule\Components\Redirects\UploadForm;
use Core\AdminModule\Components\Redirects\ValidateForm;
use PhpOffice\PhpSpreadsheet\IOFactory;

class RedirectsPresenter extends BasePresenter
{
	protected function startup()
	{
		parent::startup();
		if (!$this->getUser()->isAllowed($this->getFullModuleName(), 'settings'))
			$this->error();

		$this->setHeader('admin.title.redirects', 'fas fa-random');
	}

	/*******************************************************************************************************************
	 * ===============================  Render
	 */

	/*******************************************************************************************************************
	 * ============================== Handle
	 */

	public function handleShowUploadForm(): void
	{
		$this->template->modalTitle = $this->t('core.title.uploadRedirect');
		$this->template->modal      = 'uploadForm';
		$this->redrawControl('modal');
	}

	/*******************************************************************************************************************
	 * ============================== Actions
	 */

	public function actionDefault()
	{
		$header = [
			[
				'title' => 'core.menu.addRedirect',
				'link'  => 'redirectsGrid:add!',
				'ico'   => 'plus',
				'class' => 'ajax',
			],
		];

		if (class_exists(IOFactory::class)) {
			$header[] = [
				'title' => 'core.menu.uploadRedirect',
				'link'  => $this->link('showUploadForm!'),
				'ico'   => 'fas fa-upload',
				'class' => 'ajax',
			];
		}

		$this['navigation']->setData(['header' => $header]);
	}

	/*******************************************************************************************************************
	 * ===============================  Components
	 */

	protected function createComponentRedirectsGrid(IRedirectsGridFactory $factory): RedirectsGrid { return $factory->create(); }

	protected function createComponentUploadForm(IUploadFormFactory $factory): UploadForm
	{
		$control = $factory->create();

		$control->onSuccessUpload[] = function() {
			$this['redirectsGrid']['grid']->reload();
		};

		return $control;
	}

	protected function createComponentValidateRedirectsForm(IValidateFormFactory $factory): ValidateForm { return $factory->create(); }
}
