<?php declare(strict_types = 1);

namespace Core\ApiModule\Model\Middlewares;

use Contributte\Middlewares\IMiddleware;
use Core\Model\Helpers\Strings;
use Core\Model\Parameters;
use Nette\Utils\Json;
use Psr\Http\Message\ResponseInterface;
use Psr\Http\Message\ServerRequestInterface;

class BasicBaseAuthMiddleware implements IMiddleware
{

	/**
	 * @param ServerRequestInterface $psr7Request
	 * @param ResponseInterface      $psr7Response
	 * @param callable               $next
	 *
	 * @return ResponseInterface
	 */
	public function __invoke(ServerRequestInterface $request, ResponseInterface $response, callable $next): ResponseInterface
	{
		foreach (Parameters::load('api.basicAuthEndPoints') as $key => $url) {
			if (Strings::startsWith($request->getUri()->getPath(), $url)) {
				$authorization = $this->parseAuthorizationHeader($request->getHeaderLine('Authorization'));

				if ($authorization
					&& $authorization['key'] === Parameters::load('api.basicBaseAuth.username')
					&& $authorization['password'] === Parameters::load('api.basicBaseAuth.password')
				) {
					return $next(
						$request
							->withAttribute('authenticated', true),
						$response,
					);
				}

				$response->getBody()->write(Json::encode([
					'status'  => 'error',
					'message' => 'Client authentication failed',
					'code'    => 401,
				]));

				return $response
					->withHeader('Content-Type', 'application/json')
					->withStatus(401);
			}
		}

		return $next($request, $response);
	}

	protected function parseAuthorizationHeader(string $header): ?array
	{
		if (strpos($header, 'Basic') !== 0) {
			return null;
		}

		$header = explode(':', (string) base64_decode(substr($header, 6), true), 2);

		return [
			'key'      => $header[0],
			'password' => $header[1] ?? null,
		];
	}

}
