<?php declare(strict_types = 1);

namespace Core\FrontModule\Presenters;

use Core\FrontModule\Model\Search;
use Core\FrontModule\Model\SiteMap;

/**
 * Class DefaultPresenter
 * @package Core\FrontModule\Presenters
 */
class DefaultPresenter extends BasePresenter
{
	/** @var SiteMap @inject */
	public $siteMapService;

	/** @var Search @inject */
	public $search;

	protected function startup()
	{
		if ($this->action == 'sitemap')
			$this->skipSetInitial = true;

		parent::startup();
	}

	public function actionSearch(?string $q)
	{
		if (!$q) {
			$this->template->empty = true;
		} else {
			$this->template->q      = $q;
			$this->template->result = $this->search->search($q);
		}
	}
}
