<?php declare(strict_types = 1);

namespace Core\Model\Entities;

use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;
use Core\Model\Entities\TId;
use Nette\Utils\Json;

/**
 * @ORM\Table(name="core__setting")
 * @ORM\Entity
 */
class Setting
{

	/**
	 * @var string
	 *
	 * @ORM\Id
	 * @ORM\Column(name="`key`", type="string", length=255, nullable=false)
	 */
	public $key;

	/**
	 * @var string
	 * @ORM\Column(name="`value`", type="text", nullable=true)
	 */
	public $value;

	/**
	 * Setting constructor.
	 *
	 * @param string $key
	 * @param string $value
	 */
	public function __construct(string $key, $value)
	{
		$this->key = $key;
		$this->setValue($value);
	}

	public function setValue($value): void
	{
		if (is_array($value))
			$value = Json::encode($value);

		if ($value instanceof \DateTimeImmutable) {
			$value = $value->format('d.m.Y H:i');
		}

		$this->value = strval($value);
	}
}
