<?php declare(strict_types = 1);

namespace Core\Model\Entities;

use Doctrine;
use Doctrine\ORM\Event\LifecycleEventArgs;
use Doctrine\ORM\Mapping as ORM;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;
use Nette\Localization\ITranslator;
use Nette\SmartObject;

class TranslateListener implements EventSubscriberInterface
{
	use SmartObject;
	/** @var ITranslator */
	protected $translator;

	public function __construct(ITranslator $translator)
	{
		$this->translator = $translator;
	}

	public static function getSubscribedEvents(): array
	{
		return [];
	}

	/**
	 * @ORM\PostLoad
	 *
	 * @param object             $album
	 * @param LifecycleEventArgs $event
	 */
	public function postLoadHandler($entity, LifecycleEventArgs $event)
	{
		$entity->locale = $this->translator->getLocale();
	}
}
