<?php declare(strict_types = 1);

namespace Core\Model\Helpers;

use Nette\Neon\Neon;
use RecursiveArrayIterator;
use RecursiveIteratorIterator;

class Arrays extends \Nette\Utils\Arrays
{
	public static function isJson($string)
	{
		json_decode((string) $string);

		return (json_last_error() == JSON_ERROR_NONE);
	}

	public static function setObjectVars(object $object, array $vars): void
	{
		$has = get_object_vars($object);
		foreach ($has as $name => $oldValue) {
			if (array_key_exists($name, $vars)) {
				$object->$name = $vars[$name];
			}
		}
	}

	public static function isNeon($string)
	{
		try {
			Neon::decode($string);

			return true;
		} catch (\Exception $e) {

			return false;
		}
	}

	public static function hasOnlyNumbers(array $arr): bool
	{
		foreach ($arr as $v)
			if (!is_numeric($v))
				return false;

		return true;
	}

	public static function buildTree(array $flat, string $pidKey = 'parent', string $idKey = 'id', $initParentId = 0)
	{
		$grouped = [];
		foreach ($flat as $sub) {
			$grouped[$sub[$pidKey]][] = $sub;
		}

		$fnBuilder = function($siblings) use (&$fnBuilder, $grouped, $idKey) {
			foreach ($siblings as $k => $sibling) {
				$id = $sibling[$idKey];
				if (isset($grouped[$id])) {
					$sibling['children'] = $fnBuilder($grouped[$id]);
				}
				$siblings[$k] = $sibling;
			}

			return $siblings;
		};

		$tree = $fnBuilder($grouped[$initParentId]);

		return $tree;
	}

	public static function builtSelectOptionsTree($tree, $idKey = 'id', $titleKey = 'title', $childrenKey = 'children', &$options = [], $deep = 0)
	{
		foreach ($tree as $n) {
			$options[$n[$idKey]] = ($deep ? str_repeat('--', $deep) . ' ' : '') . $n[$titleKey];

			if (isset($n[$childrenKey]) && is_array($n[$childrenKey]))
				self::builtSelectOptionsTree($n[$childrenKey], $idKey, $titleKey, $childrenKey, $options, $deep + 1);
		}

		return $options;
	}

	public static function strposa($haystack, $needle, $offset = 0)
	{
		if (!is_array($needle))
			$needle = [$needle];
		foreach ($needle as $query) {
			if (strpos($haystack, $query, $offset) !== false)
				return true;
		}

		return false;
	}

	/**
	 * @param array       $array
	 * @param string|null $keyPrefix
	 *
	 * @return array
	 */
	public static function flattenWithDottedKeys(array $array, string $keyPrefix = null): array
	{
		$iterator = new RecursiveIteratorIterator(new RecursiveArrayIterator($array));
		$result   = [];
		foreach ($iterator as $leafValue) {
			$keys = [];
			foreach (range(0, $iterator->getDepth()) as $depth) {
				$keys[] = $iterator->getSubIterator($depth)->key();
			}
			$result[($keyPrefix ?? '') . implode('.', $keys)] = $leafValue;
		}

		return $result;
	}

	public static function shuffleAssoc($array): array
	{
		$keys = array_keys($array);

		shuffle($keys);

		foreach ($keys as $key) {
			$new[$key] = $array[$key];
		}

		$array = $new;

		return $array;
	}

	public static function search(array $array, callable $condition, bool $preserveKey = true): array
	{
		$return = [];
		foreach ($array as $k => $v) {
			if ($condition($k, $v)) {
				if ($preserveKey) {
					$return[$k] = $v;
				} else {
					$return[] = $v;
				}
			}
		}

		return $return;
	}

}
