<?php declare(strict_types = 1);

namespace Core\Model\Helpers;

class DatabaseConfig
{
	public static array $config = [];

	protected static ?string $configKey = null;

	public static function getUser(): string
	{
		return (string) self::$config[self::getConfigKey()]['user'];
	}

	public static function getPassword(): string
	{
		return (string) self::$config[self::getConfigKey()]['password'];
	}

	public static function getDbName(): string
	{
		return (string) (self::$config[self::getConfigKey()]['dbname'] ?? self::$config['default']['dbname']);
	}

	public static function getDsn(?string $dbName = null, ?string $host = null): string
	{
		$result = 'mysql:dbname=' . ($dbName ?: self::getDbName()) . ';';

		if (strtolower((string) PHP_OS) === 'linux')
			$host = '/var/lib/mysql/mysql.sock';
		else
			$host = ($host ?: self::$config[self::getConfigKey()]['host']) ?: '127.0.0.1';

		if (Strings::endsWith($host, '.soc'))
			$result .= 'unix_socket=' . $host;
		else
			$result .= 'host=' . $host;

		return $result;
	}

	public static function getConfigKey(): string
	{
		if (is_null(self::$configKey)) {
			if ((php_sapi_name() === 'cli' || strpos((string) $_SERVER['REQUEST_URI'], '/cron') === 0)
				&& isset(self::$config['cron']['user'])
				&& isset(self::$config['cron']['password']))
				self::$configKey = 'cron';
			else
				self::$configKey = 'default';
		}

		return self::$configKey;
	}
}
