<?php declare(strict_types = 1);

namespace Core\Model\Helpers;

use Doctrine\Common\Collections\Collection;
use Nette\ComponentModel\IContainer;
use Nette\Forms\Controls\SelectBox;

class FormHelper
{
	public static function fillContainerByEntity(IContainer &$container, $entity): void
	{
		foreach ($container->getControls() as $input) {
			$name = $input->getName();

			if (!isset($entity->$name) || $entity->$name instanceof Collection)
				continue;

			$value = $entity->$name;
			if (is_object($value)) {
				if (method_exists($value, 'getId'))
					$value = $value->getId();
				else if (method_exists($value, 'getIdent'))
					$value = $value->getIdent();
			}

			if ($input instanceof SelectBox) {
				if (array_key_exists($value, $input->getItems()))
					$input->setDefaultValue($value);
			} else {
				$input->setDefaultValue($value);
			}
		}
	}

	public static function fillEntityByValues(&$entity, $values): void
	{
		$valuesType = gettype($values);
		foreach (get_object_vars($entity) as $k => $v) {
			if ($valuesType === 'object' && !property_exists($values, $k)
				|| $valuesType === 'array' && !array_key_exists($k, $values))
				continue;

			if (isset($values[$k]) || $values[$k] === null)
				$entity->$k = $values[$k];
		}
	}

	public static function getTemplateFiles(string $subDirectory): array
	{
		$arr = [];

		$subDirArr = explode('/', $subDirectory);

		foreach (glob(TEMPLATES_DIR . DS . 'Front' . DS . '*', GLOB_ONLYDIR) as $dir) {
			$dirName = basename($dir);

			foreach (glob($dir . DS . $subDirectory . DS . '*.latte') as $file) {
				$fileName = pathinfo($file, PATHINFO_FILENAME);

				$arr[$dirName][$dirName . '|' . $fileName] = 'admin.' . implode('.', array_map(fn($v) => lcfirst($v), $subDirArr)) . '.' . $fileName;
			}
		}

		if (count($arr) == 1)
			$arr = array_values($arr)[0];

		return $arr;
	}
}
