<?php declare(strict_types = 1);

namespace Core\Model\Mailing;

use Core\Model\Settings;
use Core\Model\Sites;
use Core\Model\WebColors;
use Nette\Bridges\ApplicationLatte\Template;
use Nette\DI\Container;

class TemplateFactory extends AbstractTemplateFactory
{
	protected Container $container;

	public Settings $settings;

	public Sites $sites;

	public WebColors $webColors;

	public function __construct(Sites $sites, Settings $settings, WebColors $webColors, Container $container)
	{
		$this->container = $container;
		$this->sites     = $sites;
		$this->settings  = $settings;
		$this->webColors = $webColors;

		$this->setConfig($this->config);
		$this->setDefaults($this->defaults);
	}

	/**
	 * API *********************************************************************
	 */

	/**
	 * @return Template
	 */
	public function create(?string $siteIdent = null)
	{
		/** @var \Core\Model\Templating\TemplateFactory $templateFactory */
		$templateFactory = $this->container->getService('latte.templateFactory');

		/** @var Template $template */
		$template = $templateFactory->createTemplate();

		// For macros {link} {plink}
		$template->getLatte()->addProvider('uiControl', $templateFactory->linkGenerator);

		// Prepare template
		$template = $this->prepare($template);

		if ($siteIdent) {
			$site = $this->sites->getSites()[$siteIdent];

			$template->baseUrl      = 'https://' . $site->getCurrentDomain()->getDomain();
			$template->currentSite  = $site;
			$template->siteName     = $site->getSiteName();
			$template->siteSettings = $this->settings->getPrefixed($site->getIdent() . '_webSettings');
			$template->webColors    = $this->webColors->getColors($site->getIdent());
		}

		return $template;
	}
}
