<?php declare(strict_types = 1);

namespace Core\Model\Notifiers\MailNotifiers;

use Core\Model\Dao\Site;
use Core\Model\Entities\SiteText;
use Core\Model\Notifiers\ILogNotifier;
use Core\Model\Parameters;
use Nette\Localization\ITranslator;
use Nette\Mail\Message;
use Nette\Mail\SendmailMailer;

class LogNotifier implements ILogNotifier
{
	/** @var string */
	public static $developersMail;

	/** @var callable */
	public static $getUserEmails;

	/** @var Site */
	public static $site;

	/** @var ITranslator */
	public static $translator;

	/**
	 * @param string $subject
	 * @param string $message
	 */
	public static function toDevelopers(string $message, ?string $subject = null): void
	{
		/** @var SiteText $siteText */
		if (static::$site)
			$siteName = static::$site->getSiteName();
		else
			$siteName = $_SERVER['HTTP_HOST'] ?? '';

		$msg = new Message;
		$msg->setFrom(static::$site->email ?: 'noreply@pshk.cz', $siteName ?: Parameters::load('siteName'))
			->addTo(static::$developersMail)
			->setSubject($subject ?: $message)
			->setHtmlBody($message);

		(new SendmailMailer)->send($msg);
	}

	/**
	 * @param string $message
	 * @param string $subject
	 */
	public static function toCustomer(string $message, ?string $subject = null): void
	{
		/** @var SiteText $siteText */
		if (static::$site)
			$siteName = static::$site->getSiteName();
		else
			$siteName = $_SERVER['HTTP_HOST'] ?? '';

		$msg = new Message;
		$msg->setFrom(static::$site->email ?: 'noreply@pshk.cz', $siteName ?: Parameters::load('siteName'))
			->setSubject($subject ?: $message)
			->setHtmlBody($message);

		foreach (call_user_func(static::$getUserEmails) as $email) {
			$msg->addTo($email);
		}

		(new SendmailMailer)->send($msg);
	}

	protected static function parseSubject(string $subject): string
	{
		if (static::$site) {
			$subject = str_replace('%siteName%', static::$site->getSiteName(), $subject);
			$subject = str_replace('%siteDomain%', static::$site->getCurrentDomain()->getDomain(), $subject);
		}

		return $subject;
	}
}
